//Dustin Soodak

//Behavior 006
//shot 6: maintain direction with gyro
#include "MiscHardware.h"
#include "Navigation.h"
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  SetPixelRGB(2,0,0,0);SetPixelRGB(3,0,0,0);RefreshPixels();
  SwitchSerialToMotors();
  Motors(0,0);  
  SwitchPixelsToButton();
  while(!ButtonPressed());
  delay(1000);//give you time to stop touching reset button so gyro zeroes correctly
  SwitchButtonToPixels();
  SetPixelRGB(2,0,0,M_Bright);SetPixelRGB(3,0,0,M_Bright);RefreshPixels();
  delay(200);
  NavigationBegin();
  ResumeNavigation();
  RestartTimer();
}
int degr,skid,motor;
char WasCorrectDirection=0;
void loop(){
  SimpleGyroNavigation();
  degr=GetDegrees();
  skid=GetDegreesToStop();
  if(abs(degr)<2){
    Motors(0,0);  
    if(!WasCorrectDirection){
      SetPixelRGB(2,0,0,0);SetPixelRGB(3,0,0,0);RefreshPixels(); 
      WasCorrectDirection=1;
    }   
    SwitchMotorsToSerial();
    if(GetTime()>200){      
      if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough
        Serial.print("overflow ");
      Serial.print("degrees: ");
      Serial.print(GetDegrees(),DEC);
      Serial.print(", degrees per secpnd: ");
      Serial.println(GetDegreesPerSecond(),DEC);
      RestartTimer(); 
      SwitchSerialToMotors();
    }
  }
  else{       
    SwitchSerialToMotors();   
    motor=30+abs(degr+skid);
    if(motor>200)
      motor=200;      
    if(degr+skid>0)
      Motors(-motor,motor); 
    else
      Motors(motor,-motor); 
    if(WasCorrectDirection){      
      SetPixelRGB(2,0,0,M_Bright);SetPixelRGB(3,0,0,M_Bright);RefreshPixels();  
      WasCorrectDirection=0;
    }
  }
}//end loop()


